<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// Ensure this is set
$vbulletin->options['dbtech_vbmail_inactive_metric'] 	= isset($vbulletin->options['dbtech_vbmail_inactive_metric']) 		? $vbulletin->options['dbtech_vbmail_inactive_metric'] 		: 'lastvisit';
$vbulletin->options['dbtech_vbmail_inactive_threshold'] = isset($vbulletin->options['dbtech_vbmail_inactive_threshold']) 	? $vbulletin->options['dbtech_vbmail_inactive_threshold'] 	: 30;

// #############################################################################
if ($_REQUEST['action'] == 'inactivity' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_vbmail_inactive_users_list']);

	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'orderby'    => TYPE_NOHTML,
	));

	$sqlconds = array();

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}

	$sqlconds[] = $vbulletin->options['dbtech_vbmail_inactive_metric'] . " <= " . (TIMENOW - ($vbulletin->options['dbtech_vbmail_inactive_threshold'] * 86400));

	/*DBTECH_PRO_START*/
	// Make sure this is an array
	$usergroupids = @unserialize($vbulletin->options['dbtech_vbmail_inactive_usergroups']);
	$usergroupids = is_array($usergroupids) ? $usergroupids : array();

	// Get rid of this
	unset($usergroupids[0]);
	if (count($usergroupids))
	{
		$sqlconds[] = "(
			FIND_IN_SET(" . implode(', membergroupids) OR FIND_IN_SET(', $usergroupids) . ", membergroupids)
			OR usergroupid IN(" . implode(',', $usergroupids) . ")
		)";
	}
	/*DBTECH_PRO_END*/

	$counter = $db->query_first_slave("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
	");
	$totalpages = ceil($counter['total'] / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		case 'username':
			$order = 'username ASC, ' . $vbulletin->options['dbtech_vbmail_inactive_metric'] . ' ASC';
			break;
		case 'lastvisit':
			$order = 'lastvisit ASC';
			break;
		case 'lastactivity':
			$order = 'lastactivity ASC';
			break;
		case 'lastpost':
			$order = 'lastpost ASC';
			break;
		default:
			$order = $vbulletin->options['dbtech_vbmail_inactive_metric'] . ' ASC';
	}

	$logs = $db->query_read_slave("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		" . (!empty($sqlconds) ? "WHERE " . implode("\r\n\tAND ", $sqlconds) : "") . "
		ORDER BY $order
		LIMIT $startat, " . $vbulletin->GPC['perpage'] . "
	");

	if ($db->num_rows($logs))
	{
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages'\">";
		}

		$headings = array();
		$headings[] = $vbphrase['userid'];
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=username&page=" . $vbulletin->GPC['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', $vbphrase['username']) . "</a>";
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=lastvisit&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['last_visit'] . "</a>";
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=lastactivity&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['last_activity'] . "</a>";
		$headings[] = "<a href=\"vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity&pp=" . $vbulletin->GPC['perpage'] . "&orderby=lastpost&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['last_post'] . "</a>";
		$headings[] = $vbphrase['dbtech_vbmail_bounceflag'];

		print_form_header('', '');
		print_description_row(construct_link_code($vbphrase['restart'], "vbmail.php?" . $vbulletin->session->vars['sessionurl'] . "do=inactivity"), false, count($headings), 'thead', 'right');
		print_table_header(construct_phrase($vbphrase['dbtech_vbmail_inactive_users_list_page_x_y_there_are_z_total_log_entries'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter['total'])), count($headings));
		print_cells_row($headings, 1);

		while ($log = $db->fetch_array($logs))
		{
			$cell = array();
			$cell[] = $log['userid'];
			$cell[] = $log['username'];
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['lastvisit']) . '</span>';
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['lastactivity']) . '</span>';
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['lastpost']) . '</span>';
			$cell[] = ($log['dbtech_vbmail_bounceflag'] ? '<span class="col-i"><strong>' . $vbphrase['yes'] . '</strong></span>' : $vbphrase['no']);
			print_cells_row($cell, false, false, 0, 'top', false, true);
		}

		print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}
}

print_cp_footer();